import { jsxs, jsx } from "react/jsx-runtime";
import { I as InputError } from "./input-error-CBKwRgzN.js";
import { L as LoadingButton } from "./loading-button-C9msud_X.js";
import { D as Dialog, a as DialogTrigger, b as DialogContent, c as DialogHeader, d as DialogTitle } from "./dialog-Bzzm0V8u.js";
import { L as Label } from "./label-BKAgVFnB.js";
import { S as Select, a as SelectTrigger, b as SelectValue, c as SelectContent, d as SelectItem } from "./select-DLRJE4Jo.js";
import { usePage, useForm } from "@inertiajs/react";
import { useState } from "react";
import { Editor } from "richtor";
/* empty css                 */
import "./utils-Dq7odfJT.js";
import "clsx";
import "tailwind-merge";
import "lucide-react";
import "./button-CoRGprmX.js";
import "@radix-ui/react-slot";
import "class-variance-authority";
import "@radix-ui/react-dialog";
import "@radix-ui/react-label";
import "@radix-ui/react-select";
const ApplicationApproval = ({ instructor, actionComponent }) => {
  const [open, setOpen] = useState(false);
  const statuses = ["pending", "approved", "rejected"].filter((status) => status !== instructor.status);
  const { props } = usePage();
  const { translate } = props;
  const { dashboard, input, button } = translate;
  const { data, put, setData, processing, errors, reset } = useForm({
    status: "",
    feedback: ""
  });
  const handleSubmit = (e) => {
    e.preventDefault();
    put(route("instructors.status", { id: instructor.id }), {
      onSuccess: () => {
        reset();
        setOpen(false);
      }
    });
  };
  return /* @__PURE__ */ jsxs(Dialog, { open, onOpenChange: setOpen, children: [
    /* @__PURE__ */ jsx(DialogTrigger, { asChild: true, children: actionComponent }),
    /* @__PURE__ */ jsx(DialogContent, { children: /* @__PURE__ */ jsxs(DialogHeader, { children: [
      /* @__PURE__ */ jsx(DialogTitle, { children: dashboard.are_you_absolutely_sure }),
      /* @__PURE__ */ jsxs("form", { onSubmit: handleSubmit, className: "space-y-4", children: [
        /* @__PURE__ */ jsxs("div", { children: [
          /* @__PURE__ */ jsxs(Label, { children: [
            dashboard.approval_status,
            " *"
          ] }),
          /* @__PURE__ */ jsxs(Select, { required: true, value: data.status, onValueChange: (value) => setData("status", value), children: [
            /* @__PURE__ */ jsx(SelectTrigger, { children: /* @__PURE__ */ jsx(SelectValue, { placeholder: "Select the approval status" }) }),
            /* @__PURE__ */ jsx(SelectContent, { children: statuses.map((status) => /* @__PURE__ */ jsx(SelectItem, { value: status, className: "capitalize", children: status }, status)) })
          ] }),
          /* @__PURE__ */ jsx(InputError, { message: errors.status })
        ] }),
        /* @__PURE__ */ jsxs("div", { className: "pb-6", children: [
          /* @__PURE__ */ jsx(Label, { children: dashboard.feedback }),
          /* @__PURE__ */ jsx(
            Editor,
            {
              ssr: true,
              output: "html",
              placeholder: {
                paragraph: input.description_placeholder,
                imageCaption: input.image_url_placeholder
              },
              contentMinHeight: 256,
              contentMaxHeight: 640,
              initialContent: data.feedback,
              onContentChange: (value) => setData((prev) => ({
                ...prev,
                feedback: value
              }))
            }
          ),
          /* @__PURE__ */ jsx(InputError, { message: errors.feedback })
        ] }),
        /* @__PURE__ */ jsx(LoadingButton, { loading: processing, className: "w-full", children: button.submit })
      ] })
    ] }) })
  ] });
};
export {
  ApplicationApproval as default
};
